#include <stdio.h>
#include <sys/types.h>
#include <thread.h>
#include <sys/door.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <pgpUtilities.h>
#include <pgpThreads.h>
#include <pgpRPCMsg.h>

extern int debug;
PGPMutex_t sRPCMutex;

void alloc_and_return(char *, int);

void
pgpsdkproc(void *cookie, char *dataptr, size_t datasize,
	door_desc_t *descptr, size_t ndesc) {
	char *outbuf;
	int outbuflen;

	PGPMutexLock(&sRPCMutex);
	rcv_generic(dataptr, datasize, (PGPByte **)&outbuf, &outbuflen);
	alloc_and_return(outbuf, outbuflen);		// Never Returns
}

void
alloc_and_return(char *outbuf, int outbuflen)
{
	char *buf = alloca(outbuflen);
	memcpy(buf, outbuf, outbuflen);
	if (!PGPIsInitRPCBuf(outbuf))
		PGPFreeData(outbuf);
	PGPMutexUnlock(&sRPCMutex);

	door_return(buf, outbuflen, NULL, 0);
}

run_pgpsdkd()
{
	int fd, n;

	PGPMutexCreate(&sRPCMutex, NULL);

	pgpRPCCreateBEContext();	/* does PGPsdkInit() too..  */

	fd = door_create(pgpsdkproc, NULL, 0);
	if (fd == -1) {
		perror("door_create");
		exit(1);
	}

	unlink("/tmp/pgpsdkdoor");
	close(open("/tmp/pgpsdkdoor", O_CREAT|O_RDWR, 0777));
	n = fattach(fd, "/tmp/pgpsdkdoor"); 
	if (n == -1) {
		perror("fattach");
		exit(1);
	}

	for (;;)
		pause();
}

void
pgpRPCGetUnixClientAuth(pgpRPCconnection *conn_ref)
{
	door_cred_t info;
	char name[20];
	PGPByte *cp;

	door_cred(&info);

	sprintf(name, "%d", info.dc_euid);
	cp = PGPNewData(PGPGetDefaultMemoryMgr(), strlen(name)+1,0);
	pgpCopyMemory(name, cp, strlen(name)+1);
	conn_ref->UserName = cp;
	conn_ref->uid = info.dc_euid;
	conn_ref->gid = info.dc_egid;
	conn_ref->pid = info.dc_pid;
}

PGPBoolean
pgpRPCVerifyUnixClientAuth(pgpRPCconnection *conn_ref)
{
	door_cred_t info;

	if (door_cred(&info) == -1)
		return FALSE;

	if ((info.dc_euid == conn_ref->uid) && (info.dc_pid == conn_ref->pid)) {
		setuid(info.dc_euid);
		return TRUE;
	}
	else
		return FALSE;
}

